# Copyright 2005, @Last Software, Inc.

# This software is provided as an example of using the Ruby interface
# to SketchUp.

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------

# This adds some useful functions to the Utilities menu in SketchUp
require 'sketchup.rb'
require 'extensions.rb'
require 'LangHandler.rb'

$uStrings = LanguageHandler.new("Utilities")

utilitiesExtension = SketchupExtension.new $uStrings.GetString("Utilities Tools"), "Utilities/utilitiesTools.rb"
                    
utilitiesExtension.description=$uStrings.GetString("Adds Tools->Utilities to the SketchUp inteface.  The Utilities submenu contains three tools: Create Face, Query Tool and Fix Non-planar Faces.")
                        
Sketchup.register_extension utilitiesExtension, false


